package org.msh.etbm.services.mobile;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.msh.etbm.services.mobile.init.*;
import org.msh.etbm.services.mobile.model.AdminUnitData;
import org.msh.etbm.services.mobile.model.TbCaseData;
import org.msh.tb.entities.Tbunit;

import java.util.List;

/**
 * Generate the initialization data used by the mobile, according to the initialization step
 *
 * Created by rmemoria on 8/3/17.
 */
@Name("mobileInitService")
@Scope(ScopeType.APPLICATION)
@AutoCreate
public class MobileInitService {

    public List<AdminUnitData> generateInitDataStep1(Tbunit unit) {
        Step1InitGenerator gen = new Step1InitGenerator();
        return gen.generate(unit);
    }

    public AdministrationResponse generateIniDataStep2(Tbunit unit) {
        Step2InitGenerator gen = new Step2InitGenerator();
        return gen.generate(unit);
    }

    public List<TbCaseData> generateIniDataStep3(Tbunit unit) {
        Step3InitGenerator gen = new Step3InitGenerator();
        return gen.generate(unit);
    }

    public CaseData1Response generateIniDataStep4(Tbunit unit) {
        Step4InitGenerator gen = new Step4InitGenerator();
        return gen.generate(unit);
    }

    public CaseData2Response generateIniDataStep5(Tbunit unit) {
        Step5InitGenerator gen = new Step5InitGenerator();
        return gen.generate(unit);
    }
}
